#include <bits/stdc++.h>

using namespace std;

using ll = long long;

struct Node
{
    int cnt[5];
    int swp[5][5];

    Node()
    {
        for ( int i=0; i<5; i++ )
        for ( int j=0; j<5; j++ )
            swp[i][j] = 0;

        for ( int i=0; i<5; i++ )
        {
            cnt[i] = 0;
            swp[i][i] = 1;
        }
    }
};

/*Node mrg_cnt ( Node x, Node y )
{
    for ( int i=0; i<5; i++ )
        x.cnt[i] += y.cnt[i];
    return x;
}*/

int n, m;
string s;
vector<int> a;
vector<Node> tree;

void build ( int v, int tl, int tr )
{
    if ( tl == tr )
    {
        tree[v] = Node();
        tree[v].cnt[ a[tl] ] = 1;
        return;
    }

    int mid = ( tl + tr ) / 2;

    build( 2*v, tl, mid );
    build( 2*v+1, mid+1, tr );

    for ( int i=0; i<5; i++ )
        tree[v].cnt[i] = tree[2*v].cnt[i] + tree[2*v+1].cnt[i];
}

void mrg_swp ( int x, int y ) /// !!!! in x from y
{
    if ( x == y ) return;

    for ( int i=0; i<5; i++ )
    {
        int cur = 0;

        for ( int j=0; j<5; j++ )
        if ( tree[x].swp[i][j] )
        {
            cur = j;
            break;
        }

        for ( int j=0; j<5; j++ )
        if ( tree[y].swp[cur][j] )
        {
            cur = j;
            break;
        }

        for ( int j=0; j<5; j++ )
            tree[x].swp[i][j] = 0;

        tree[x].swp[i][cur] = 1;
    }
}

void push ( int v, int tl, int tr )
{
    if ( tl == tr )
    {
        int pos = 0;

        for ( int i=0; i<5; i++ )
        if ( tree[v].cnt[i] )
            pos = i;

        tree[v].cnt[pos]--;

        for ( int i=0; i<5; i++ )
        if ( tree[v].swp[pos][i] )
        {
            pos = i;
            break;
        }

        tree[v].cnt[pos]++;

        for ( int i=0; i<5; i++ )
        for ( int j=0; j<5; j++ )
            tree[v].swp[i][j] = 0;

        for ( int i=0; i<5; i++ )
            tree[v].swp[i][i] = 1;

        return;
    }

    int nex[5] = {0};

    for ( int i=0; i<5; i++ )
    for ( int j=0; j<5; j++ )
    if ( tree[v].swp[i][j] )
        nex[j] += tree[v].cnt[i];

    for ( int i=0; i<5; i++ )
        tree[v].cnt[i] = nex[i];

    mrg_swp( 2*v, v );
    mrg_swp( 2*v+1, v );

    for ( int i=0; i<5; i++ )
    for ( int j=0; j<5; j++ )
        tree[v].swp[i][j] = 0;

    for ( int i=0; i<5; i++ )
        tree[v].swp[i][i] = 1;
}

int fnd ( int v, int tl, int tr, int ch, int x )
{
    push( v, tl, tr );

    if ( tl == tr )
        return tl;

    int mid = ( tl + tr ) / 2;

    push( 2*v, tl, mid );
    push( 2*v+1, mid+1, tr );

    if ( tree[2*v].cnt[ch] >= x )
        return fnd( 2*v, tl, mid, ch, x );

    return fnd( 2*v+1, mid+1, tr, ch, x - tree[2*v].cnt[ch] );
}

void upd ( int v, int tl, int tr, int r, int ch1, int ch2 )
{
    push( v, tl, tr );

    if ( tr <= r )
    {
        for ( int i=0; i<5; i++ )
            tree[v].swp[ch1][i] = 0;
        tree[v].swp[ch1][ch2] = 1;

        push( v, tl, tr );

        return;
    }

    int mid = ( tl + tr ) / 2;

    upd( 2*v, tl, mid, r, ch1, ch2 );

    if ( mid+1 <= r )
        upd( 2*v+1, mid+1, tr, r, ch1, ch2 );

    push( 2*v, tl, mid );
    push( 2*v+1, mid+1, tr );

    for ( int i=0; i<5; i++ )
        tree[v].cnt[i] = tree[2*v].cnt[i] + tree[2*v+1].cnt[i];

    for ( int i=0; i<5; i++ )
    for ( int j=0; j<5; j++ )
        tree[v].swp[i][j] = 0;

    for ( int i=0; i<5; i++ )
        tree[v].swp[i][i] = 1;
}

void dfs ( int v, int tl, int tr )
{
    //if ( tl == tr )
        push( v, tl, tr );

    if ( tl == tr )
    {
        int pos = 0;

        for ( int i=0; i<5; i++ )
        if ( tree[v].cnt[i] )
            pos = i;

        //cout << pos << ' ';
        cout << char('a' + pos);

        return;
    }

    int mid = ( tl + tr ) / 2;

    dfs( 2*v, tl, mid );
    dfs( 2*v+1, mid+1, tr );
}

int main ()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    cin >> n >> m >> s;

    a.resize(n);

    for ( int i=0; i<n; i++ )
        a[i] = s[i]-'a';

    tree.assign( 4*n+100, Node() );

    /*for ( auto& el : a )
        cout << el << ' ';
    cout << '\n';*/

    build( 1, 0, n-1 );

    /*for ( int i=0; i<5; i++ )
        cout << tree[1].cnt[i] << ' ';
    cout << '\n';*/

    /*cout << "!!!: ";
    dfs( 1, 0, n-1 );
    cout << '\n';*/

    while ( m-- )
    {
        int x;
        char l, r;
        cin >> x >> l >> r;

        if ( l == r )
            continue;

        int pos = fnd( 1, 0, n-1, l-'a', x );

        upd( 1, 0, n-1, pos, l-'a', r-'a' );
    }

    dfs( 1, 0, n-1 );

    return 0;
}
